/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextComponent;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.JCBooleanEditor;
import jclass.chart.customizer.JCFileNameEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;

public class JCSaveDialog
extends JCPropertyPage
implements JCActionListener {
    JCCheckboxGroup modeBox;
    JCBooleanEditor paramCheck;
    JCBooleanEditor serialCheck;
    JCFileNameEditor fileSelector;
    JCLabel saveLabel;
    JCLabel savedLabel;
    JCButton addButton;
    JCButton previewButton;
    JCButton removeButton;
    JCButton cancelButton;
    Object preview;
    Object target;

    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new BorderLayout());
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new JCGridLayout(3, 1));
        JCContainer jCContainer3 = new JCContainer();
        jCContainer3.setLayout(new JCAlignerLayout(2, 1, 3));
        jCContainer3.add(new JCLabel("Save:"));
        this.saveLabel = new JCLabel("Nothing yet");
        this.saveLabel.setFont(new Font("TimesRoman", 1, 14));
        this.saveLabel.setPreferredSize(290, -999);
        this.saveLabel.setAlignment(3);
        jCContainer3.add(this.saveLabel);
        jCContainer2.add(jCContainer3);
        String string = "Save to ";
        this.modeBox = new JCCheckboxGroup(string);
        this.modeBox.setInsets(new Insets(3, 3, 1, 1));
        this.modeBox.setLayout(new GridLayout(1, 2, 1, 3));
        this.paramCheck = new JCBooleanEditor("Param File");
        this.paramCheck.addPropertyChangeListener(this);
        this.modeBox.add(this.paramCheck);
        this.serialCheck = new JCBooleanEditor("Serialized File");
        this.serialCheck.addPropertyChangeListener(this);
        this.modeBox.add(this.serialCheck);
        jCContainer2.add(this.modeBox);
        JCContainer jCContainer4 = new JCContainer();
        jCContainer4.setLayout(new JCAlignerLayout(2, 1, 3));
        jCContainer4.add(new JCLabel("File:"));
        this.fileSelector = new JCFileNameEditor();
        this.fileSelector.init();
        ((JCTextComponent)this.fileSelector.nameField).setText("test.html");
        this.fileSelector.loadButton.disable();
        this.fileSelector.addPropertyChangeListener(this);
        jCContainer4.add(this.fileSelector);
        jCContainer4.add(new JCLabel("Saved:"));
        this.savedLabel = new JCLabel("Nothing yet");
        this.savedLabel.setFont(new Font("TimesRoman", 1, 14));
        this.savedLabel.setPreferredSize(290, -999);
        this.savedLabel.setAlignment(3);
        jCContainer4.add(this.savedLabel);
        jCContainer2.add(jCContainer4);
        jCContainer.add("Center", jCContainer2);
        JCContainer jCContainer5 = new JCContainer();
        jCContainer5.setLayout(new FlowLayout(1, 10, 2));
        if (this.hasPreview()) {
            this.previewButton = new JCButton("Preview");
            this.previewButton.disable();
            this.previewButton.addActionListener(this);
            jCContainer5.add(this.previewButton);
        }
        this.cancelButton = new JCButton("Cancel");
        this.cancelButton.addActionListener(this);
        jCContainer5.add(this.cancelButton);
        jCContainer.add("South", jCContainer5);
        this.add("South", jCContainer);
        this.paramCheck.setState(1);
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        this.target = object;
        if (this.target == null) {
            this.saveLabel.setText("Nyet");
        } else {
            this.saveLabel.setText(this.target.toString());
        }
        if (this.hasPreview() && this.preview != null) {
            this.showPreview();
        }
    }

    public boolean hasPreview() {
        return false;
    }

    public void showPreview() {
        Object object = this.getObject();
        if (object == null) {
            if (this.preview != null) {
                this.remove((Component)this.preview);
                this.preview = object;
                JCPropertyPage.resizeFrame(this);
                return;
            }
        } else {
            if (object instanceof JCChart) {
                this.preview = object;
                JCChart jCChart = (JCChart)object;
                if (this.preview instanceof Component) {
                    this.remove((Component)this.preview);
                }
                this.add("Center", jCChart);
                JCPropertyPage.resizeFrame(this);
                return;
            }
            JCCustomizerPage.showError("Preview not available for:" + object);
        }
    }

    public void showSaved(Object object, String string) {
        if (object == null) {
            this.savedLabel.setText("Nyet");
        } else {
            this.savedLabel.setText("Chart saved to '" + string + "'");
            this.preview = object;
        }
        if (this.hasPreview() && this.preview != null) {
            this.showPreview();
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.cancelButton) {
            ((Component)JCPropertyPage.getFrame(this)).hide();
            return;
        }
        if (jCActionEvent.getSource() == this.addButton) {
            this.firePropertyChange(null, null, this.getObject());
            ((Component)JCPropertyPage.getFrame(this)).hide();
            return;
        }
        if (jCActionEvent.getSource() == this.previewButton) {
            this.showPreview();
            return;
        }
        if (jCActionEvent.getSource() == this.removeButton) {
            this.setObject(null);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 instanceof Boolean) {
            ((Boolean)object2).booleanValue();
            if (object == this.paramCheck) {
                ((JCTextComponent)this.fileSelector.nameField).setText("*.html");
                return;
            }
            if (object == this.serialCheck) {
                ((JCTextComponent)this.fileSelector.nameField).setText("*.ser");
                return;
            }
        } else if (object == this.fileSelector.nameField || object == this.fileSelector.saveButton) {
            this.fileSelector.getDirectory();
            String string = this.fileSelector.getFile();
            if (((Boolean)this.serialCheck.getValue()).booleanValue()) {
                this.saveSerialized(string);
                return;
            }
            if (((Boolean)this.paramCheck.getValue()).booleanValue()) {
                this.saveParams(string);
            }
        }
    }

    private void saveParams(String string) {
        if (this.target instanceof JCChart) {
            try {
                JCChart jCChart = (JCChart)this.target;
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                jCChart.setSaveParamStream(fileOutputStream);
                String string2 = jCChart.getName();
                if (string2 == null) {
                    string2 = "JCChart";
                }
                jCChart.saveParams(string2);
                this.showSaved(this.getObject(), string);
                fileOutputStream.close();
                return;
            }
            catch (Exception exception) {
                JCCustomizerPage.showError("Failed to save Param file:\n" + exception);
                exception.printStackTrace(System.out);
                return;
            }
        }
    }

    private void saveSerialized(String string) {
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.getObject());
                this.showSaved(this.getObject(), string);
                fileOutputStream.close();
                return;
            }
            catch (Exception exception) {
                JCCustomizerPage.showError("Failed to save serialized file:\n" + exception);
                exception.printStackTrace(System.out);
                return;
            }
        }
    }

    public void launch() {
        Frame frame = JCPropertyPage.getFrame(this);
        if (frame == null) {
            try {
                frame = this.getDialogFrame();
                frame.setTitle(JCSaveDialog.getPageTitle());
                frame.setLayout(new GridLayout(1, 1));
                frame.add(this);
                frame.pack();
                Dimension dimension = this.preferredSize();
                frame.resize(dimension.width + 10, dimension.height + 30);
            }
            catch (Throwable throwable) {
                JCCustomizerPage.showError("JCCustomizerPage launch():\n" + throwable);
                frame = null;
            }
        }
        if (frame != null) {
            frame.show();
        }
    }

    public static void main(String[] stringArray) {
        String string = JCSaveDialog.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(JCSaveDialog.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public static String getPageTitle() {
        return "JClass Save Dialog";
    }

    public static String getPageName() {
        return "JCSaveDialog";
    }
}

